/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception.  You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "https://www.silverpeas.org/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.silverpeas.core.contribution.content.form.dummy;

import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.field.TextFieldImpl;
import org.silverpeas.core.util.ArrayUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * A dummy DataRecord .
 */
public class DummyDataRecord implements DataRecord {

  private static final long serialVersionUID = -3169937693303520239L;
  private final Field field;

  public DummyDataRecord() {
    field = new TextFieldImpl();
  }

  public DummyDataRecord(Field field) {
    this.field = field;
  }

  @Override
  public String getId() {
    return "id";
  }

  @Override
  public void setId(String externalId) {
    // nothing to do
  }

  @Override
  public boolean isNew() {
    return true;
  }

  @Override
  public Field getField(String fieldName) {
    return field;
  }

  @Override
  public Field getField(String fieldName, int occurrence) {
    return field;
  }

  @Override
  public Field getField(int fieldIndex) {
    return field;
  }

  @Override
  public int size() {
    return 1;
  }

  @Override
  public String[] getFieldNames() {
    return ArrayUtil.emptyStringArray();
  }

  @Override
  public String getLanguage() {
    return null;
  }

  @Override
  public void setLanguage(String language) {
    // nothing to do
  }

  @Override
  public Map<String, String> getValues(String language) {
    return new HashMap<>();
  }

  @Override
  public ResourceReference getResourceReference() {
    return null;
  }
}